%% C. Cantore (2021)
%% Tractable Heterogeneous Agents Models 
%% CIMS Summer School - University of Surrey


%%=========================================================================
% Reproduces figures in session 3 based on material from Vincent Sterk
%%=========================================================================
 


clc
clear 
close all



% parameters
p.beta=0.99;              % subjective discount factor
p.eps=9;                  % elasticity of subst. goods varieties
p.phi=1;                  % inverse Frische elasticity of labor supply
p.sig=1;                  % coefficient of risk aversion 
p.ksi=1.5;                % coefficient Taylor rule (inflation)
p.pdur=4;                 % average price duration (in quarters)
p.calvo=1-1/p.pdur;       % Calvo probability of adjustment
p.phiR=p.calvo*(p.eps-1)/((1-p.calvo)*(1-p.beta*p.calvo)); % implied Rotemberg parameter (exploit first-order equivalence)
p.peu=0.03;               % job loss prob
p.pue=0.6;                % job finding prob 
p.u=p.peu/(p.pue+p.peu);  % unemployment rate
p.closs=0.2;              % consumption drop upon job loss in s.s.
p.Rbar=1/(p.beta*(p.peu*((1-p.closs)^(-p.sig))+1-p.peu)); % gross real interest rate in s.s.
p.rhoA=0.9;               % persistence TFP shock
p.rhoR=0.5;               % persistence monetary policy shock
p.kappa=(p.eps-1)/p.eps;  % normalize kappa to ensure Ne=1 --> kappa=w=(eps-1)/eps) (use labour supply condition and Phillips Curve)
p.discount=p.beta*p.Rbar*(1-p.peu);
save params p;

% plot determinacy region
%dynare ZLHANK_determinacy.mod;


% solve ZL-HANK model
%dynare ZLHANK_full.mod;  % full form
dynare ZLHANK_reduced.mod; % 2 equation form
IRF.ZLHANK.eA.Y=Y_eA;
IRF.ZLHANK.eA.PI=PI_eA;
IRF.ZLHANK.eA.A=A_eA;
IRF.ZLHANK.eR.Y=Y_eR;
IRF.ZLHANK.eR.PI=PI_eR;
IRF.ZLHANK.eR.zR=zR_eR;



% solve RANK model
dynare RANK_reduced.mod noclearall;   % 2 equation form
IRF.RANK.eA.Y=Y_eA;
IRF.RANK.eA.PI=PI_eA;
IRF.RANK.eR.Y=Y_eR;
IRF.RANK.eA.A=A_eA;
IRF.RANK.eR.PI=PI_eR;
IRF.RANK.eR.PI=PI_eR;
IRF.RANK.eR.zR=zR_eR;

figure(2)
subplot(1,3,1)
plot(IRF.ZLHANK.eA.Y,'k-','Linewidth',1.5,'MarkerSize',4);hold
plot(IRF.RANK.eA.Y,'r:','Linewidth',1.5)
title('Output (Y)');ylabel('%');xlabel('quarter')
subplot(1,3,2)
plot(IRF.ZLHANK.eA.PI,'k-','Linewidth',1.5,'MarkerSize',4);hold
plot(IRF.RANK.eA.PI,'r:','Linewidth',1.5)
title('Inflation (PI)');ylabel('%');xlabel('quarter')
subplot(1,3,3)
plot(IRF.ZLHANK.eA.A,'k-','Linewidth',1.5,'MarkerSize',4);hold
plot(IRF.RANK.eA.A,'r:','Linewidth',1.5)
title('TFP (A)');ylabel('%');xlabel('quarter')
legend('ZL-HANK','RANK')

figure(3)
subplot(1,3,1)
plot(IRF.ZLHANK.eR.Y,'k-','Linewidth',1.5,'MarkerSize',4);hold
plot(IRF.RANK.eR.Y,'r:','Linewidth',1.5)
title('Output (Y)');ylabel('%');xlabel('quarter')
subplot(1,3,2)
plot(IRF.ZLHANK.eR.PI,'k-','Linewidth',1.5,'MarkerSize',4);hold
plot(IRF.RANK.eR.PI,'r:','Linewidth',1.5)
title('Inflation (PI)');ylabel('%');xlabel('quarter')
subplot(1,3,3)
plot(IRF.ZLHANK.eR.zR,'k-','Linewidth',1.5,'MarkerSize',4);hold
plot(IRF.RANK.eR.zR,'r:','Linewidth',1.5)
title('policy shock (zR)');ylabel('%');xlabel('quarter')
legend('ZL-HANK','RANK')

% redistribution experiment
dynare ZLHANK_full.mod;  % full form
IRF.ZLHANK.T.Y=Ne_eT;
IRF.ZLHANK.T.PI=PI_eT;
IRF.ZLHANK.T.T=T_eT;

figure(4)
subplot(1,3,1)
plot(IRF.ZLHANK.T.Y,'k-','Linewidth',1.5,'MarkerSize',4);hold
plot(0*IRF.RANK.eR.Y,'r:','Linewidth',1.5)
title('Output (Y)');ylabel('%');xlabel('quarter')
ylim([-0.02 0.12])
subplot(1,3,2)
plot(IRF.ZLHANK.T.T,'k-','Linewidth',1.5,'MarkerSize',4);hold
plot(0*IRF.RANK.eR.PI,'r:','Linewidth',1.5)
title('Inflation (PI)');ylabel('%');xlabel('quarter')
ylim([-0.02 0.12])
subplot(1,3,3)
plot(IRF.ZLHANK.T.T,'k-','Linewidth',1.5,'MarkerSize',4);hold
plot(0*IRF.RANK.eR.zR,'r:','Linewidth',1.5)
title('Tax on employed (T)');ylabel('% of s.s. output');xlabel('quarter')
legend('ZL-HANK','RANK')
ylim([-0.02 0.12])