load params

// variables and parameters
var Y PI A zR;
varexo eA eR;
parameters beta eps phi sig ksi phiR Rbar rhoA rhoR peu;


// parameter values
set_param_value('beta',p.beta);
set_param_value('eps',p.eps);
set_param_value('phi',p.phi);
set_param_value('sig',p.sig);
set_param_value('ksi',p.ksi);
set_param_value('phiR',p.phiR);
set_param_value('Rbar',p.Rbar);
set_param_value('peu',p.peu);
set_param_value('rhoA',p.rhoA);
set_param_value('rhoR',p.rhoR);


// Model declaration
model;

// Euler equation
-sig*Y + sig*beta*Rbar*(1-peu)*Y(+1) = ksi*PI - PI(+1) + zR;

// Price setting equation (Phillips Curve)
((eps-1)/phiR)*((phi+sig)*Y-(1+phi)*A) = PI - beta*PI(+1);

// Evolution shocks
A=rhoA*A(-1)+eA;
zR=rhoR*zR(-1)+eR(-12); %FG shock
%zR=rhoR*zR(-1)+eR; %standard MP shock

end;

initval;
Y=0;
PI=0;
A=0;
zR=0;
end;

shocks;
var eA;  stderr 1;
var eR;  stderr 1;
end;
resid;

check;
steady;
stoch_simul(order=1,irf=24,nograph); 