load params

// variables and parameters
var Ce Ne PI w R A zR T;
varexo eA eR eT;
parameters beta eps phi sig ksi kappa phiR Rbar rhoA rhoR peu pue THETA u;


// parameter values
set_param_value('beta',p.beta);
set_param_value('eps',p.eps);
set_param_value('phi',p.phi);
set_param_value('sig',p.sig);
set_param_value('kappa',p.kappa);
set_param_value('THETA',1-p.closs);
set_param_value('ksi',p.ksi);
set_param_value('phiR',p.phiR);
set_param_value('Rbar',p.Rbar);
set_param_value('peu',p.peu);
set_param_value('pue',p.pue);
set_param_value('u',p.u);
set_param_value('rhoA',p.rhoA);
set_param_value('rhoR',p.rhoR);


// Model declaration
model;

// Euler equation
(exp(Ce))^(-sig) = beta*exp(R)/exp(PI(+1))*((1-peu)*exp(Ce(+1))^(-sig)+peu*THETA^(-sig));

// labor supply
exp(w)*(exp(Ce)^(-sig)) = kappa*exp(Ne)^phi;

// Price setting equation (Phillips Curve)
1-eps+eps*exp(w)/exp(A) = phiR*exp(PI)*(exp(PI)-1) - phiR*beta*exp(PI(+1))*(exp(PI(+1))-1);

// Monetary Policy
exp(R)/Rbar=exp(zR)*exp(PI)^ksi;

// aggregate resource constraint
exp(Ce) + T + phi*exp(Ne)*exp(A)*(exp(PI)-1)^2 = exp(Ne)*exp(A);

// Evolution shocks
A=rhoA*A(-1)+eA;
zR=rhoR*zR(-1)+eR;
T=eT;
end;

initval;
Ce=0;
Ne=0;
PI=0;
w=log((eps-1)/eps);
R=log(Rbar);
A=0;
zR=0;
end;

shocks;
var eA;  stderr 1;
var eR;  stderr 1;
var eT;  stderr 0.1;
end;
resid;

check;
steady;
stoch_simul(order=1,irf=24,nograph); 