load params

// variables and parameters
var Ce Ne PI w R A zR C2 N2 B2;
varexo eA eR ee;
parameters beta eps phi sig ksi kappa phiR Rbar rhoA rhoR peu pue theta u;


// parameter values
set_param_value('beta',p.beta);
set_param_value('eps',p.eps);
set_param_value('phi',p.phi);
set_param_value('sig',p.sig);
set_param_value('kappa',p.kappa);
set_param_value('theta',1-p.closs);
set_param_value('ksi',p.ksi);
set_param_value('phiR',p.phiR);
set_param_value('Rbar',p.Rbar);
set_param_value('peu',p.peu);
set_param_value('pue',p.pue);
set_param_value('u',p.u);
set_param_value('rhoA',p.rhoA);
set_param_value('rhoR',p.rhoR);


// Model declaration
model;

// Euler equation
(exp(Ce))^(-sig) = beta*exp(R)/exp(PI(+1))*((1-peu)*exp(Ce(+1))^(-sig)+peu*theta^(-sig));
(exp(C2))^(-sig) = beta*exp(R)/exp(PI(+1))*((1-peu)*exp(C2(+1))^(-sig)+peu*(theta+exp(R)/exp(PI(+1))*B2)^(-sig)); %% New

// labor supply
exp(w)*(exp(Ce)^(-sig)) = kappa*exp(Ne)^phi;
exp(w)*(exp(C2)^(-sig)) = kappa*exp(N2)^phi; %% New

// Price setting equation (Phillips Curve)
1-eps+eps*exp(w)/exp(A) = phiR*exp(PI)*(exp(PI)-1) - phiR*beta*exp(PI(+1))*(exp(PI(+1))-1);

// Monetary Policy
exp(R)/Rbar=exp(zR)*exp(PI)^ksi;

// aggregate resource constraint
exp(Ce) + phiR*exp(Ne)*exp(A)*(exp(PI)-1)^2 = exp(Ne)*exp(A);
exp(C2) + B2= exp(w)*exp(N2)+(exp(A)*exp(Ne)-exp(w)*exp(Ne)-(phiR*exp(Ne)*exp(A)*(exp(PI)-1)^2))/(1-u)+exp(R(-1))/exp(PI)*B2(-1)+ee; %% New

// Evolution shocks
A=rhoA*A(-1)+eA;
zR=rhoR*zR(-1)+eR;
end;

initval;
Ce=0;
Ne=0;
PI=0;
w=log((eps-1)/eps);
R=log(Rbar);
A=0;
zR=0;
C2=0;
N2=0;
B2=0;
end;

shocks;
var eA;  stderr 0;
var eR;  stderr 0;
var ee;  stderr 1;
end;
resid;

check;
steady;
stoch_simul(order=1,irf=120); 

