%% C. Cantore (2021)
%% Tractable Heterogeneous Agents Models 
%% CIMS Summer School - University of Surrey


%%=========================================================================
% Reproduces figures in session 3 on MPC exercise based on material from Vincent Sterk
%%=========================================================================
 



clc
clear 
close all



% parameters
p.beta=0.99;              % subjective discount factor
p.eps=9;                  % elasticity of subst. goods varieties
p.phi=1;                  % inverse Frische elasticity of labor supply
p.sig=1;                  % coefficient of risk aversion 
p.ksi=1.5;                % coefficient Taylor rule (inflation)
p.pdur=4;                 % average price duration (in quarters)
p.calvo=1-1/p.pdur;       % Calvo probability of adjustment
p.phiR=p.calvo*(p.eps-1)/((1-p.calvo)*(1-p.beta*p.calvo)); % implied Rotemberg parameter (exploit first-order equivalence)
p.peu=0.03;               % job loss prob
p.pue=0.6;                % job finding prob 
p.u=p.peu/(p.pue+p.peu);  % unemployment rate
p.closs=0.2;              % consumption drop upon job loss in s.s.
p.Rbar=1/(p.beta*(p.peu*((1-p.closs)^(-p.sig))+1-p.peu)); % gross real interest rate in s.s.
p.rhoA=0.9;               % persistence TFP shock
p.rhoR=0.5;               % persistence monetary policy shock
p.kappa=(p.eps-1)/p.eps;  % normalize kappa to ensure Ne=1 --> kappa=w=(eps-1)/eps) (use labour supply condition and Phillips Curve)
p.discount=p.beta*p.Rbar*(1-p.peu);
save params p;

dynare ZLHANK_full_MPC1.mod;  % full form

%% 2. MPC of an employed household.
figure
plot(C2_ee(1:10),'Linewidth',1.5);
title('MPC of Employed'), xlabel('horizon (quarters)')


%% 3. Compute the average MPC across the entire population, in the first quarter as well as in subsequent quarters.
T=120;
MPC_avg2(1)=u+(1-u)*C2_ee(1);       % average MPC in the initial period
for t=2:T
    MPC_avg2(t)=(1-p.peu)^(t-2)*(1-u)*p.peu*p.Rbar*B2_ee(t-1)+(1-p.peu)^(t-1)*(1-u)*C2_ee(t);
end
%% (1-u)*peu*R B(-1)+(1-peu)(1-u)*C+(1-peu)*(1-u)*peu(R B(-2)+(1-peu)(1-peu)(1-u) C(-1).....
%% Sum from t=2 to T (1-peu)^(t-2) (1-u) peu R B(-1) + (1-u) Sum from t=2 to T (1-peu)^t-1 C

%% 4. Plot the average MPCs, cumulated over time. 
figure
plot(cumsum(MPC_avg2),'Linewidth',1.5)
title('cumulative MPC'), xlabel('horizon (quarters)')
