% generates a rectangular grid from the information in fspace
% as generated by linapprox.m
function grid = rectgrid(fspace)
  nn = prod(fspace.n);
  dim = fspace.d;
  indx = (0:nn-1)';
  grid = zeros(nn,dim);
  for d=dim:-1:1
    nd = fspace.n(d);
    id = mod(indx,nd) + 1;
    g = fspace.grid(d,:);
    grid(:,d) = g(id)';
    indx = floor(indx ./ nd);
  end;
