%compute the steady state of NK Model 

function [ys,params,check]=GK_equity_SW_steadystate(ys,exo,M_,options_);

%%
%% DO NOT CHANGE THIS PART.
%%
%% Here we load the values of the deep parameters in a loop.
%%
NumberOfParameters = M_.param_nbr;
for ii = 1:NumberOfParameters
  paramname = M_.param_names{ii};
  eval([ paramname ' = M_.params(' int2str(ii) ');']);
end
% initialize indicator
check = 0;

%% THIS BLOCK IS MODEL SPECIFIC.
%%
%% Here the user has to define the steady state.
%%

Hbar=0.5;

x0=[log(Hbar);  log(5.0); log(0.47); log(0.0025) ];
options = optimset('TolFun',1e-9,'TolX',1e-9,'MaxIter', 5000, 'MaxFunEvals', 5000, 'Display','on');
[x,~] = fsolve(@ss_fun_GK_equity_SW,x0,options);
H=exp(x(1));
KYW=exp(x(2));
thetaFF=exp(x(3));
xiB=exp(x(4));

g=g_bar;
PIE=PIE_bar;

PIEw=PIE_bar*(1+g);

if index==1
%
%with complete indexing
%
PIEtilde=1;
PIEwtilde=1;
PIEwptilde=1;
else
PIEtilde=PIE^(1-gammap);
PIEwtilde=PIEw/PIE^gammaw;
PIEwptilde=PIE^(1-gammaw);
end
A=A_bar;
bettag=betta*(1+g)^(-sigma_c);
R=1.0/bettag;


PO=((1-xip*PIEtilde^(zzeta-1))/(1-xip))^(1/(1-zzeta));
MC=(1-1/zzeta)*PO*(1-bettag*(1+g)*xip*PIEtilde^zzeta)/(1-bettag*(1+g)*xip*PIEtilde^(zzeta-1));

if wage>0
WO=((1-xiw*PIEwtilde^(muw-1))/(1-xiw))^(1/(1-muw));
Deltaw=(1-xiw)/(1-xiw*PIEwtilde^muw)*WO^(-muw);
Invmarkup=(1-1/muw)*WO*(1-bettag*xiw*(1+g)*PIEwtilde^muw)/(1-bettag*xiw*PIEwtilde^muw*PIEwptilde^(-1));

else
%Sticky Eages
%
WO=1;
Deltaw=1;
Invmarkup=1;   
end  




PWP=MC;
Deltap=((1-xip)*(((1-xip*PIEtilde^(zzeta-1))/(1-xip))^(1/(1-zzeta)))^(-zzeta))/(1-xip*PIEtilde^zzeta);

IY=(delta+g)*KYW/(1+g)*Deltap;

CY=1-IY-gy;
Hd=H/Deltaw;
YW=A*Hd*(KYW/(1+g))^((1-alp)/alp);
Y=YW/Deltap;
K=KYW*YW;
I=IY*Y;
G=gy*Y;
W=alp*PWP*YW/Hd;
Wh=W*Invmarkup;
C=CY*Y;


U=((C*(1-chi/(1+g)))^(1-sigma_c)*exp((sigma_c-1)*H^(1+sigma_l)/(1+sigma_l)) -1)/(1-sigma_c);
CEequiv=((1.01*(C*(1-chi/(1+g)))^(1-sigma_c)*exp((sigma_c-1)*H^(1+sigma_l)/(1+sigma_l))-1)/(1-sigma_c)-U)/(1-bettag*(1+g));
Omega=U/(1-bettag*(1+g));
UC=(C*(1-chi/(1+g)))^(-sigma_c)*exp((sigma_c-1)*H^(1+sigma_l)/(1+sigma_l));
UH=-UC*H^(sigma_l)*C*(1-chi/(1+g));


%
if  habit==1
%
%external habit
%
lam=UC;
%
else
%
%internal habit
%
lam=UC*(1-bettag*chi);
%
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


LAMBDA=bettag;
S=0;
Sdash=0;
Q=1;
X=1+g;

JJp=Y/(1-bettag*(1+g)*xip*PIEtilde^(zzeta-1));
JJtilde=(PIEtilde^(zzeta-1))*JJp;
Jp=(1/(1-1/zzeta))*Y*MC/(1-bettag*(1+g)*xip*PIEtilde^(zzeta));
Jtilde=PIEtilde^zzeta*Jp;

if wage>0
JJw=Hd/(1-bettag*xiw*PIEwtilde^muw/PIEwptilde);
Jw=(1/(1-(1/muw)))*Wh*Hd/(1-bettag*xiw*(1+g)*PIEwtilde^muw);
else
JJw=Hd;
Jw=Hd*Wh;   
end


MCS=1;
MRSS=1;
MPS=1;
RPS=1;

IS=1;
Rn=1/bettag*PIE;
ER=1/bettag;

%
%Banking Sector
%
Sasset=K;
Q=1;

RK=((1-alp)*PWP*YW/(K/(1+g))+(1-delta)*Q)/Q;
xequity=xequitytarg;
kappaFF=-epsilon/xequitytarg;
qE=xequity*Q*Sasset;
Re=R;
%mue=0;
N=((RK*(sigmaB+xiB)-sigmaB*R)*Q*Sasset-sigmaB*(Re-R)*qE)/(1+g-sigmaB*R);
D=Q*Sasset-N-qE;
phiB=Q*Sasset/N;
lever=Q*Sasset/(N+qE);
Thetax=thetaFF*(1+epsilon*xequity+kappaFF*xequity^2/2);
omega=1-sigmaB+Thetax*sigmaB*phiB;
%nud=omega;
%mus=Thetax-nud/phiB;
q=(1-alp)*PWP*YW/(K/(1+g))/(Re-(1-delta));
%lambda=(mus+mue*xequity)/(Thetax-mus-mue*xequity);
DThetax=0;
spread=RK-R;
E=qE/q;


spread=RK-R;
epsAtrendstate=0;









%% END OF THE MODEL SPECIFIC BLOCK.

%% DO NOT CHANGE THIS PART.
%%
%% Store model parameters
params=NaN(NumberOfParameters,1);
for iter = 1:length(M_.params) %update parameters set in the file
  eval([ 'params(' num2str(iter) ') = ' M_.param_names{iter} ';' ])
end

NumberOfEndogenousVariables = M_.orig_endo_nbr; %auxiliary variables are set automatically
for ii = 1:NumberOfEndogenousVariables
  varname = M_.endo_names{ii};
  eval(['ys(' int2str(ii) ') = ' varname ';']);
end    
